@extends('layouts.vendor.app')

@section('title',translate('messages.restaurant_wallet'))

@push('css_or_js')

@endpush

@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
     <div class="page-header">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <h2 class="page-header-title text-capitalize">
                        <div class="card-header-icon d-inline-flex mr-2 img">
                            <img src="{{dynamicAsset('/public/assets/admin/img/image_90.png')}}" alt="public">
                        </div>
                        <span>
                            {{translate('messages.restaurant_wallet')}}
                        </span>
                    </h2>
                </div>
            </div>
        </div>
<!-- End Page Header -->
<?php
$wallet = \App\Models\RestaurantWallet::where('vendor_id',\App\CentralLogics\Helpers::get_vendor_id())->first();
if(isset($wallet)==false){
    \Illuminate\Support\Facades\DB::table('restaurant_wallets')->insert([
        'vendor_id'=>\App\CentralLogics\Helpers::get_vendor_id(),
        'created_at'=>now(),
        'updated_at'=>now()
    ]);
    $wallet = \App\Models\RestaurantWallet::where('vendor_id',\App\CentralLogics\Helpers::get_vendor_id())->first();
}
?>
@include('vendor-views.wallet.partials._balance_data',['wallet'=>$wallet])
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table id="datatable"
                                class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                                data-hs-datatables-options='{
                                    "order": [],
                                    "orderCellsTop": true,
                                    "paging":false
                                }' >
                            <thead class="thead-light">
                            <tr>
                                <th>{{ translate('messages.sl') }}</th>
                                <th>{{translate('messages.amount')}}</th>
                                <th>{{translate('messages.Payment_Time')}}</th>
                                <th>{{translate('messages.Payment_method')}}</th>
                                <th>{{translate('messages.status')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($account_transaction as $k=>$wr)

                                <tr>
                                    <td scope="row">{{$k+$account_transaction->firstItem()}}</td>
                                    <td> {{ \App\CentralLogics\Helpers::format_currency($wr['amount'])}}</td>

                                    <td>
                                        <span class="d-block">{{ \App\CentralLogics\Helpers::time_date_format($wr['created_at'])}}</span>
                                    </td>
                                    <td>
                                        @if($wr->method)
                                        {{ translate($wr->method) }}
                                        @else
                                            {{ translate('Default_method') }}
                                        @endif
                                    </td>
                                    <td>
                                        <label class="badge badge-soft-success">{{translate('messages.approved')}}</label>
                                    </td>

                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        @if(count($account_transaction) === 0)
                        <div class="empty--data">
                            <img src="{{dynamicAsset('/public/assets/admin/img/empty.png')}}" alt="public">
                            <h5>
                                {{translate('no_data_found')}}
                            </h5>
                        </div>
                        @endif
                    </div>
                </div>
                <div class="card-footer pt-0 border-0">
                    {{$account_transaction->links()}}
                </div>
            </div>
        </div>
    </div>
</div>


                <div class="modal fade" id="payment_model" tabindex="-1"  role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{translate('messages.Pay_Via_Online')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>

                        </div>
                        <form action="{{ route('vendor.wallet.make_payment') }}" method="POST" class="needs-validation">
                        <div class="modal-body">
                                @csrf
                                <input type="hidden" value="{{ \App\CentralLogics\Helpers::get_restaurant_id() }}" name="restaurant_id"/>
                                <input type="hidden" value="{{  abs($wallet->collected_cash) }}" name="amount"/>
                                <h5 class="mb-5 ">{{ translate('Pay_Via_Online') }} &nbsp; <small>({{ translate('Faster_&_secure_way_to_pay_bill') }})</small></h5>
                                <div class="row g-3">
                                    @forelse ($data as $item)
                                        <div class="col-sm-6">
                                            <div class="d-flex gap-3 align-items-center">
                                                <input type="radio" required id="{{$item['gateway'] }}" name="payment_gateway" value="{{$item['gateway'] }}">
                                                <label for="{{$item['gateway'] }}" class="d-flex align-items-center gap-3 mb-0">
                                                    <img height="24" src="{{ dynamicStorage('storage/app/public/payment_modules/gateway_image/'. $item['gateway_image']) }}" alt="">
                                                    {{ $item['gateway_title'] }}
                                                </label>
                                            </div>
                                        </div>
                                    @empty
                                    <h1>{{ translate('no_payment_gateway_found') }}</h1>
                                    @endforelse
                                </div>
                        </div>

                        <div class="modal-footer">
                            <button id="reset_btn" type="reset" data-dismiss="modal" class="btn btn-secondary" >{{ translate('Close') }} </button>
                            <button type="submit" class="btn btn-primary">{{ translate('Proceed') }}</button>
                        </div>
                        </form>
                    </div>
                    </div>
                </div>


                <div class="modal fade" id="Adjust_wallet" tabindex="-1"  role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{translate('messages.Adjust_Wallet')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>

                        </div>
                        <form action="{{ route('vendor.wallet.make_wallet_adjustment') }}" method="POST" class="needs-validation">
                        <div class="modal-body">
                                @csrf
                                <h5 class="mb-5 ">{{ translate('This_will_adjust_the_collected_cash_on_your_earning') }} </h5>
                        </div>

                        <div class="modal-footer">
                            <button id="reset_btn" type="reset" data-dismiss="modal" class="btn btn-secondary" >{{ translate('Close') }} </button>
                            <button type="submit" class="btn btn-primary">{{ translate('Proceed') }}</button>
                        </div>
                        </form>
                    </div>
                    </div>
                </div>









@endsection
@push('script')
<script>
    "use strict";
    $('#withdraw_method').on('change', function () {
        let method_id = this.value;

        // Set header if need any otherwise remove setup part
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "{{route('vendor.wallet.method-list')}}" + "?method_id=" + method_id,
            data: {},
            processData: false,
            contentType: false,
            type: 'get',
            success: function (response) {
                let method_fields = response.content.method_fields;
                $("#method-filed__div").html("");
                method_fields.forEach((element, index) => {
                    $("#method-filed__div").append(`
                    <div class="form-group mt-2">
                        <label for="wr_num" class="fz-16 text-capitalize c1 mb-2">${element.input_name.replaceAll('_', ' ')}</label>
                        <input type="${element.input_type == 'phone' ? 'number' : element.input_type  }" class="form-control" name="${element.input_name}" placeholder="${element.placeholder}" ${element.is_required === 1 ? 'required' : ''}>
                    </div>
                `);
                })

            },
            error: function () {

            }
        });
    });

    $('.payment-warning').on('click',function (event ){
            event.preventDefault();
            toastr.info(
                "{{ translate('messages.Currently,_there_are_no_payment_options_available._Please_contact_admin_regarding_any_payment_process_or_queries.') }}", {
                    CloseButton: true,
                    ProgressBar: true
                });
        });


    function showMyModal(data) {
        $(".modal-body #hiddenValue").html(data);
        $('#exampleModal').modal('show');
    }
    $('.withdrawal-methods-disable').on('click', function (){
    toastr.info( $(this).data('message') , {
        CloseButton: true,
        ProgressBar: true
        });
    })


    $(document).ready(function() {
        $("#withdraw_form").on("submit", function(event) {
            $('#set_disable').attr('disabled', true);

        });
    });
</script>
@endpush
