<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1\Call;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class AnnotationOptions {
    /**
     * @param string $answeredBy Indicates the answering entity as determined by
     *                           Answering Machine Detection.
     * @param string $connectivityIssue Indicates if the call had any connectivity
     *                                  issue
     * @param string $qualityIssues Indicates if the call had audio quality issues.
     * @param bool $spam Call spam indicator
     * @param int $callScore Call Score
     * @param string $comment User comments
     * @param string $incident Call tag for incidents or support ticket
     * @return UpdateAnnotationOptions Options builder
     */
    public static function update(string $answeredBy = Values::NONE, string $connectivityIssue = Values::NONE, string $qualityIssues = Values::NONE, bool $spam = Values::NONE, int $callScore = Values::NONE, string $comment = Values::NONE, string $incident = Values::NONE): UpdateAnnotationOptions {
        return new UpdateAnnotationOptions($answeredBy, $connectivityIssue, $qualityIssues, $spam, $callScore, $comment, $incident);
    }
}

class UpdateAnnotationOptions extends Options {
    /**
     * @param string $answeredBy Indicates the answering entity as determined by
     *                           Answering Machine Detection.
     * @param string $connectivityIssue Indicates if the call had any connectivity
     *                                  issue
     * @param string $qualityIssues Indicates if the call had audio quality issues.
     * @param bool $spam Call spam indicator
     * @param int $callScore Call Score
     * @param string $comment User comments
     * @param string $incident Call tag for incidents or support ticket
     */
    public function __construct(string $answeredBy = Values::NONE, string $connectivityIssue = Values::NONE, string $qualityIssues = Values::NONE, bool $spam = Values::NONE, int $callScore = Values::NONE, string $comment = Values::NONE, string $incident = Values::NONE) {
        $this->options['answeredBy'] = $answeredBy;
        $this->options['connectivityIssue'] = $connectivityIssue;
        $this->options['qualityIssues'] = $qualityIssues;
        $this->options['spam'] = $spam;
        $this->options['callScore'] = $callScore;
        $this->options['comment'] = $comment;
        $this->options['incident'] = $incident;
    }

    /**
     * Which entity answered the call as determined by Answering Machine Detection. Use this to provide feedback on Answering Machine Detection accuracy. Possible enumerated values, one of: human, machine. human indicates the call was answered by a person. machine indicates the call was answered by an answering machine.
     *
     * @param string $answeredBy Indicates the answering entity as determined by
     *                           Answering Machine Detection.
     * @return $this Fluent Builder
     */
    public function setAnsweredBy(string $answeredBy): self {
        $this->options['answeredBy'] = $answeredBy;
        return $this;
    }

    /**
     * Specify if the call had any connectivity issues. Possible enumerated values, one : no_connectivity_issue, invalid_number, caller_id, dropped_call, number_reachability.
     *
     * @param string $connectivityIssue Indicates if the call had any connectivity
     *                                  issue
     * @return $this Fluent Builder
     */
    public function setConnectivityIssue(string $connectivityIssue): self {
        $this->options['connectivityIssue'] = $connectivityIssue;
        return $this;
    }

    /**
     * Specify if the call had any subjective quality issues. Possible values, one or more of:  no_quality_issue, low_volume, choppy_robotic, echo, dtmf, latency, owa, static_noise. Use comma separated values to indicate multiple quality issues for the same call
     *
     * @param string $qualityIssues Indicates if the call had audio quality issues.
     * @return $this Fluent Builder
     */
    public function setQualityIssues(string $qualityIssues): self {
        $this->options['qualityIssues'] = $qualityIssues;
        return $this;
    }

    /**
     * Specify if the call was a spam call. Use this to provide feedback on whether calls placed from your account were marked as spam, or if inbound calls received by your account were unwanted spam. Is of type Boolean: true, false. Use true if the call was a spam call.
     *
     * @param bool $spam Call spam indicator
     * @return $this Fluent Builder
     */
    public function setSpam(bool $spam): self {
        $this->options['spam'] = $spam;
        return $this;
    }

    /**
     * Specify the call score. This is of type integer. Use a range of 1-5 to indicate the call experience score, with the following mapping as a reference for rating the call [5: Excellent, 4: Good, 3 : Fair, 2 : Poor, 1: Bad].
     *
     * @param int $callScore Call Score
     * @return $this Fluent Builder
     */
    public function setCallScore(int $callScore): self {
        $this->options['callScore'] = $callScore;
        return $this;
    }

    /**
     * Specify any comments pertaining to the call. This of type string with a max limit of 100 characters. Twilio does not treat this field as PII, so don’t put any PII in here.
     *
     * @param string $comment User comments
     * @return $this Fluent Builder
     */
    public function setComment(string $comment): self {
        $this->options['comment'] = $comment;
        return $this;
    }

    /**
     * Associate this call with an incident or support ticket. This is of type string with a max limit of 100 characters. Twilio does not treat this field as PII, so don’t put any PII in here.
     *
     * @param string $incident Call tag for incidents or support ticket
     * @return $this Fluent Builder
     */
    public function setIncident(string $incident): self {
        $this->options['incident'] = $incident;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.UpdateAnnotationOptions ' . $options . ']';
    }
}